; These two lines go in every installer.
#define VFPCoreFiles    "..\..\Runtimes"
#include VFPCoreFiles + "\VFPCoreFiles.txt"

; Define the location of the application files.
#define AppFiles        "..\"

; Define the application name, executable, company, copyright, etc.
#define MyAppRoot       "myapp"
#define MyApplication   MyAppRoot + ".exe"
#define MyHelp          MyAppRoot + ".chm"
#define MyAppName       "My Application"
#define MyAppID         MyAppName
#define MyURL           "http://www.stonefieldquery.com"
#define MyVersion       GetFileVersion(MyApplication)
#define MyCompany       "Stonefield Software Inc."
#define MyCopyright     "Copyright  2014 Stonefield Software Inc. All rights reserved."

[Setup]
AppName={#MyAppName}
AppID={#MyAppID}
AppVerName={#MyAppName}
AppVersion={#MyVersion}
AppPublisher={#MyCompany}
AppPublisherURL={#MyURL}
AppSupportURL={#MyURL}
AppUpdatesURL={#MyURL}
AppendDefaultDirName=no
DefaultDirName={pf}\{#MyAppName}
DefaultGroupName={#MyAppName}
DisableProgramGroupPage=false
LicenseFile=eula.rtf
Compression=lzma
SolidCompression=true
PrivilegesRequired=admin
UninstallDisplayIcon={#AppFiles}Source\myapp.ico
OutputBaseFilename=setup
AppCopyright={#MyCopyright}
VersionInfoDescription={#MyAppName} Setup
VersionInfoVersion={#MyVersion}
VersionInfoTextVersion={#MyVersion}
VersionInfoCompany={#MyCompany}
VersionInfoCopyright={#MyCopyright}
ShowLanguageDialog=yes
WizardImageFile=InstallLogo.bmp
WizardSmallImageFile=compiler:WizModernSmallImage-IS.bmp
InfoBeforeFile=beforefile.rtf
SignedUninstaller=yes
; Standard is defined as:
; "C:\Program Files (x86)\Microsoft SDKs\Windows\v7.1a\Bin\signtool.exe" sign /f <location of PFX> /p <password for PFX> $p
SignTool=Standard /d $q{#MyAppName}$q $f

[Tasks]
Name: desktopicon; Description: Create a &desktop icon; GroupDescription: Icons

[Files]
Source: "{#AppFiles}\{#MyApplication}";  DestDir: "{app}";  Flags: ignoreversion
Source: "{#AppFiles}\{#MyHelp}";         DestDir: "{app}";  Flags: ignoreversion
Source: "{#AppFiles}\ComServer.dll";     DestDir: "{app}";  Flags: ignoreversion regserver
Source: "{#AppFiles}\CheckUpdate.exe";   DestDir: "{app}";  Flags: ignoreversion
Source: "{#AppFiles}\UpdateApp.exe";     DestDir: "{app}";  Flags: ignoreversion

; Needed because we're using the TreeView control.
Source: "{#VFPCoreFiles}\MSComCtl.ocx";  DestDir: "{sys}";  Flags: onlyifdoesntexist sharedfile regserver noregerror

; Needed because we're using XMLAdapter.
Source: "{#VFPCoreFiles}\MSXML4.dll";    DestDir: "{sys}";  Flags: onlyifdoesntexist sharedfile regserver noregerror
Source: "{#VFPCoreFiles}\MSXML4R.dll";   DestDir: "{sys}";  Flags: onlyifdoesntexist sharedfile

; Needed because we have a multi-threaded DLL.
Source: "{#VFPCoreFiles}\VFP9T.dll";     DestDir: "{app}";  Flags: ignoreversion
                                        
[Icons]
Name: "{group}\{#MyAppName}";                        Filename: "{app}\{#MyApplication}";  WorkingDir: "{app}"
Name: "{group}\{#MyAppName} Help";                   Filename: "{app}\{#MyHelp}"
Name: "{group}\{cm:UninstallProgram,{#MyAppName}}";  Filename: "{uninstallexe}"
Name: "{commondesktop}\{#MyAppName}";                Filename: "{app}\{#MyApplication}";  WorkingDir: "{app}";  Tasks: desktopicon

[Run]
Filename: "{app}\{#MyApplication}";  Description: "{cm:LaunchProgram,{#MyAppName}}";  Flags: nowait postinstall skipifsilent

[Registry]
; License for MSCOMCTL.OCX classes
Root: HKCR; Subkey: "Licenses\ED4B87C4-9F76-11D1-8BF7-0000F8754DA1"; ValueType: string; ValueData: "knlggnmntgggrninthpgmnngrhqhnnjnslsh"
